VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Using SRQ feature of 485 with CEC488 and KPCI-488"
   ClientHeight    =   7635
   ClientLeft      =   2640
   ClientTop       =   1680
   ClientWidth     =   7665
   Icon            =   "frmBuffer.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7635
   ScaleWidth      =   7665
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox chkZeroCheck 
      Caption         =   "Release Zero Check"
      Height          =   255
      Left            =   480
      TabIndex        =   10
      Top             =   2160
      Width           =   2655
   End
   Begin VB.TextBox txtNumPts 
      Height          =   285
      Left            =   2640
      TabIndex        =   7
      Text            =   "10"
      Top             =   1680
      Width           =   615
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   720
      TabIndex        =   6
      Top             =   4920
      Width           =   2175
   End
   Begin VB.CommandButton cmdGet 
      Caption         =   "Display Data"
      Enabled         =   0   'False
      Height          =   495
      Left            =   720
      TabIndex        =   5
      Top             =   4200
      Width           =   2175
   End
   Begin VB.TextBox GPIBaddr 
      Height          =   285
      Left            =   1680
      TabIndex        =   3
      Text            =   "6"
      Top             =   1080
      Width           =   495
   End
   Begin VB.ListBox List1 
      Height          =   4350
      Left            =   3720
      TabIndex        =   2
      Top             =   720
      Width           =   3015
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Enabled         =   0   'False
      Height          =   495
      Left            =   720
      TabIndex        =   1
      Top             =   3480
      Width           =   2175
   End
   Begin VB.CommandButton cmdSetup 
      Caption         =   "Setup"
      Height          =   495
      Left            =   720
      TabIndex        =   0
      Top             =   2760
      Width           =   2175
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      Caption         =   "KEITHLEY"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   24
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   495
      Left            =   360
      TabIndex        =   16
      Top             =   240
      Width           =   2655
   End
   Begin VB.Label Label7 
      Caption         =   "RQS; SRQ"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   165
      Left            =   1875
      TabIndex        =   15
      Top             =   6750
      Width           =   765
   End
   Begin VB.Line Line4 
      X1              =   1425
      X2              =   1725
      Y1              =   6825
      Y2              =   6825
   End
   Begin VB.Line Line3 
      X1              =   1425
      X2              =   1425
      Y1              =   6225
      Y2              =   6825
   End
   Begin VB.Line Line2 
      X1              =   2160
      X2              =   2895
      Y1              =   6600
      Y2              =   6600
   End
   Begin VB.Label Label6 
      Caption         =   "Reading Done ( Green = bit is set)"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   180
      Left            =   3075
      TabIndex        =   14
      Top             =   6525
      Width           =   2430
   End
   Begin VB.Line Line1 
      X1              =   2160
      X2              =   2160
      Y1              =   6240
      Y2              =   6600
   End
   Begin VB.Label Label5 
      Caption         =   "B7"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   1080
      TabIndex        =   13
      Top             =   6240
      Width           =   255
   End
   Begin VB.Label Label4 
      Caption         =   "B0"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2835
      TabIndex        =   12
      Top             =   6240
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "SRQ and Serial Poll Info : "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   1080
      TabIndex        =   11
      Top             =   5760
      Width           =   1815
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   7
      Left            =   1080
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   6
      Left            =   1320
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   5
      Left            =   1560
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   4
      Left            =   1800
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   3
      Left            =   2040
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   2
      Left            =   2280
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   1
      Left            =   2520
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Shape shpSRQBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   0
      Left            =   2760
      Shape           =   5  'Rounded Square
      Top             =   6000
      Width           =   255
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Push Setup"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   3720
      TabIndex        =   9
      Top             =   5400
      Width           =   3255
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Number of Samples: "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   8
      Top             =   1680
      Width           =   2175
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "GPIB Addr: "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   360
      TabIndex        =   4
      Top             =   1080
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim status As Integer
Dim cmd As String  ' variable used to send commands
Dim read As String ' variable used to enter data from the picoammeter
Dim l As Integer  ' length of read
Dim Data() As String ' declare an undimensioned string to store readings



'
'  This example uses the CEC488 driver for GPIB control
'  of the model 485 picoammeter.  Since it uses the
'  CEC488 driver, it requires a Keithley GPIB card: KPCI-488 or
'  KPC-488.2 or KPC-488.2AT
'
'   If using an NI or other vendor GPIB card, you will need to modify
'   this program to make use of their GPIB driver syntax
'
'   A Model 485 was used.  This example programs the 485 to assert SRQ
'   when all the requested measurements have been made.
'
'   A 6485 will work with this program if it is configured for DDC mode.
'
'   Because the 485 does not give you access to the 100 point buffer via the GPIB bus,
'   you need to create an array (Data) to store the readings during the GET and
'   read the readings from the array later.
'
'
'

Private Sub chkZeroCheck_Click()
    
    If chkZeroCheck.Value = 1 Then
        cmd$ = "C0X"  ' Disable Zero Check
        Call send(GPIBaddr.Text, cmd$, status%)
        chkZeroCheck.Caption = "Zero Check Released"
    Else
        cmd$ = "C1X"  ' Enable Zero Check
        Call send(GPIBaddr.Text, cmd$, status%)
        chkZeroCheck.Caption = "Release Zero Check"
    End If
    
End Sub

Private Sub cmdExit_Click()
' UNT = UNTALK
' UNL = UNLISTEN
' GTL = GO TO LOCAL
' DCL = DEVICE CLEAR
Call transmit("UNT UNL GTL DCL", status%)
Unload Me
End
End Sub

Private Sub cmdGet_Click()
Dim i As Integer
For i = 0 To (CInt(txtNumPts.Text) - 1)
    List1.AddItem "Reading " & Str(i) & " : " & Data(i)
Next i
    
cmdGet.Enabled = False
cmdSetup.Enabled = True
lblStatus.Caption = "Data displayed above"
    
End Sub

Private Sub cmdSetup_Click()
List1.Clear
Dim i As Integer
For i = 0 To 7
    shpSRQBit(i).FillColor = vbRed
Next i

    cmd$ = "R0X"  ' Auto Range
    Call send(GPIBaddr.Text, cmd$, status%)
    
    cmd$ = "G1X"  ' ASCII without prefix
    Call send(GPIBaddr.Text, cmd$, status%)
    
    cmd$ = "M8X"  ' SRQ on Reading Done
    Call send(GPIBaddr.Text, cmd$, status%)
      
    cmd$ = "T2X"  ' Trigger continuous on GET
    Call send(GPIBaddr.Text, cmd$, status%)
  
lblStatus.Caption = "Push the Start Button"
cmdSetup.Enabled = False
cmdStart.Enabled = True
  
 End Sub

Private Sub cmdStart_Click()
Dim j, x As Integer
x = Val(txtNumPts.Text)
ReDim Data(x)
cmdStart.Enabled = False

' issue a bus trigger, Group Execute Trigger
Call transmit("GET", status%)
    
For j = 0 To (Val(txtNumPts.Text) - 1)
    Call enter(read, 255, l, Val(GPIBaddr.Text), status%)
    Data(j) = read
    lblStatus.Caption = "Waiting for SRQ...."
     
    Do
    DoEvents
    Loop Until srq  ' srq is a function of CEC488 API
Next j

lblStatus.Caption = "SRQ detected...."

Dim poll As Integer
Dim SRQBits(8) As Byte
Dim i As Integer
Call spoll(GPIBaddr.Text, poll, status%)
    For i = 0 To 7
        SRQBits(i) = poll And 2 ^ i
    Next i
    For i = 0 To 7
        If SRQBits(i) And 2 ^ i = 2 ^ i Then
        shpSRQBit(i).FillColor = vbGreen
        Else
        shpSRQBit(i).FillColor = vbRed
        End If
    Next i
If (poll And 72) = 72 Then  ' 72 = Reading Done
    cmdGet.Enabled = True
    lblStatus.Caption = "Measurements are done"
Else
    cmdGet.Enabled = False
    lblStatus.Caption = "Instrument not in Ready Mode"
End If

End Sub

Private Sub Form_Unload(Cancel As Integer)
' UNT = UNTALK
' UNL = UNLISTEN
' GTL = GO TO LOCAL
' DCL = DEVICE CLEAR
Call transmit("UNT UNL GTL DCL", status%)
Unload Me
End
End Sub
